/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.gun;

import dev.toma.configuration.config.Configurable;
import dev.toma.gunsrpg.api.common.IJamConfig;
import dev.toma.gunsrpg.api.common.IWeaponConfig;
import dev.toma.gunsrpg.config.gun.JamConfig;
import lib.toma.animations.Easings;

public final class SimpleWeaponConfiguration
implements IWeaponConfig {
    @Configurable
    @Configurable.DecimalRange(min=1.0, max=10000.0)
    @Configurable.Comment(value={"Projectile velocity"})
    @Configurable.Gui.NumberFormat(value="0.0###")
    public float velocity;
    @Configurable
    @Configurable.Comment(value={"Weapon jamming settings"})
    public IJamConfig jamConfig;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Visual recoil multiplier"})
    @Configurable.Gui.NumberFormat(value="0.0##")
    public float recoilAnimationScale = 1.0f;

    public SimpleWeaponConfiguration(float velocity, float jamMin, float jamMax) {
        this(velocity, jamMin, jamMax, IJamConfig.DEFAULT_EASING);
    }

    public SimpleWeaponConfiguration(float velocity, float jamMin, float jamMax, Easings easing) {
        this.velocity = velocity;
        this.jamConfig = new JamConfig(jamMin, jamMax, easing);
    }

    @Override
    public float getDamage() {
        return 0.0f;
    }

    @Override
    public float getVelocity() {
        return this.velocity;
    }

    @Override
    public int getGravityDelay() {
        return 0;
    }

    @Override
    public IJamConfig getJamConfig() {
        return this.jamConfig;
    }

    @Override
    public float getRecoilAnimationScale() {
        return this.recoilAnimationScale;
    }
}

